<?php
/* -----------------------------------------------------------------
 * 	$Id: paypal_webhook.php 1548 2016-04-06 13:03:10Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	modified eCommerce Shopsoftware
 * 	http://www.modified-shop.org
 * 	Copyright (c) 2009 - 2013 [www.modified-shop.org]
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

require('includes/application_top.php');
require_once(DIR_FS_EXTERNAL.'paypal/classes/PayPalAdmin.php');
$paypal = new PayPalAdmin();

if (isset($_GET['action'])) {
  switch ($_GET['action']) {
    case 'delete':
      $paypal->delete_webhook($_GET['id']);      
      xtc_redirect(xtc_href_link('paypal_webhook.php'));
      break;

    case 'update':
      $paypal->update_webhook($_POST['config']);      
      xtc_redirect(xtc_href_link('paypal_webhook.php'));
      break;

    case 'insert':
      $paypal->create_webhook($_POST['config']);      
      xtc_redirect(xtc_href_link('paypal_webhook.php'));
      break;
  }
}

$orders_statuses = array(array('id' => '-1', 'text' => TEXT_PAYPAL_NO_STATUS_CHANGE));
$orders_status_array = array('-1' => TEXT_PAYPAL_NO_STATUS_CHANGE);
$orders_status_query = xtc_db_query("SELECT orders_status_id,
                                            orders_status_name
                                       FROM ".TABLE_ORDERS_STATUS."
                                      WHERE language_id = '".$_SESSION['languages_id']."'
                                   ORDER BY sort_order");
while ($orders_status = xtc_db_fetch_array($orders_status_query)) {
  $orders_statuses[] = array ('id' => $orders_status['orders_status_id'], 'text' => $orders_status['orders_status_name']);
  $orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
}

$status_array = array(
  array('id' => '1', 'text' => YES),
  array('id' => '0', 'text' => NO),
); 

$landingpage_array = array(
  array('id' => 'Login', 'text' => 'Login'),
  array('id' => 'Payment', 'text' => 'Payment'),
); 

require (DIR_WS_INCLUDES.'header.php');
?>
<table class="table table-striped table-bordered">
	<tr>
		<th colspan="5"><?php echo TEXT_PAYPAL_WEBHOOK_HEADING_TITLE; ?></th>
	</tr>
	<tr>
	  <?php
		$list = $paypal->list_webhooks();
		$new = true;
		if (count($list) > 0) {
		  foreach ($list as $data) {
			if ($data['url'] == xtc_catalog_href_link('callback/paypal/webhook.php', '', 'SSL', false)) {
			  $new = false;
			  break;
			}
		  }
		}
		if (!isset($_GET['action']) && $new != false) {
		  echo '<div class="pageHeading flt-l" style="margin: 3px 40px;"><a class="button" href="'.xtc_href_link('paypal_webhook.php', 'action=new').'">'.BUTTON_INSERT.'</a></div>';
		}
		echo '<td><a href="'.xtc_href_link('paypal_config.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_CONFIG.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_profile.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_PROFILE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_webhook.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_WEBHOOK.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_module.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_MODULE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_payment.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_TRANSACTIONS.'</a></td>';
	  ?>
	</tr>
</table>
<table class="table table-striped table-bordered">
<?php
  if (isset($_GET['action']) && $_GET['action'] == 'edit') {
	$list = $paypal->edit_webhook($_GET['id']);
  
	echo xtc_draw_form('config', 'paypal_webhook.php', xtc_get_all_get_params(array('action')).'action=update');
	echo xtc_draw_hidden_field('config[id]', $_GET['id']);

	for ($i=0, $t=count($list); $i<$t; $i++) {
	  ?>
	  <tr>
		<td><?php echo $list[$i]['name']; ?></td>
		<td>
		  <?php 
			echo '<div class="check">'.xtc_draw_checkbox_field('config[data]['.$i.'][name]', $list[$i]['name'], (($list[$i]['status'] === true) ? 'checked="checked"' : '')).'</div>'; 
			echo '<div class="drop">'.xtc_draw_pull_down_menu('config[data]['.$i.'][orders_status]', $orders_statuses, $list[$i]['orders_status'], 'style="width: 300px;"').'</div>';
		  ?>
		</td>
		<td><?php echo $list[$i]['description']; ?></td>
	  </tr>
	  <?php
	}
	?>
	<tr>
	  <td colspan="3">
		<a class="btn btn-default btn-sm" href="<?php echo xtc_href_link('paypal_webhook.php'); ?>"><?php echo BUTTON_CANCEL; ?></a>
		<input type="submit" class="btn btn-success btn-sm" name="submit" value="<?php echo BUTTON_UPDATE; ?>">
	  </td>
	</tr>
	<?php              
  } elseif (isset($_GET['action']) && $_GET['action'] == 'new') {
  
	$list = $paypal->available_webhooks();
	
	if (is_array($list) && count($list) > 0) {
	  echo xtc_draw_form('config', 'paypal_webhook.php', xtc_get_all_get_params(array('action')).'action=insert');
	  for ($i=0, $t=count($list); $i<$t; $i++) {
		?>
		<tr>
		  <td><?php echo $list[$i]['name']; ?></td>
		  <td>
			<?php 
			  echo xtc_draw_checkbox_field('config[data]['.$i.'][name]', $list[$i]['name'], 'checked="checked"'); 
			  echo xtc_draw_pull_down_menu('config[data]['.$i.'][orders_status]', $orders_statuses, '-1', 'style="width: 300px;"');
			?>
		  </td>
		  <td><?php echo $list[$i]['description']; ?></td>
		</tr>
		<?php
	  }
	  ?>
	  <tr>
		<td colspan="3">
		  <a class="btn btn-default btn-sm" href="<?php echo xtc_href_link('paypal_webhook.php'); ?>"><?php echo BUTTON_CANCEL; ?></a>
		  <input type="submit" class="btn btn-success btn-sm" name="submit" value="<?php echo BUTTON_SAVE; ?>">
		</td>
	  </tr>
	  <?php
	} else {
	  echo '<div class="info_message">'.TEXT_PAYPAL_WEBHOOK_CREDENTIAL_INFO.'</div>';
	}
  } else {
	if (count($list) > 0) {
	  for ($i=0, $n=count($list); $i<$n; $i++) {
		?>
		  <tr>
			<td><?php echo TABLE_HEADING_URL; ?></td>
			<td colspan="2"><?php echo $list[$i]['url']; ?></td>
		  </tr> 
		  <tr>
			<td><?php echo TABLE_HEADING_WEBHOOK; ?></td>
			<td><?php echo TABLE_HEADING_STATUS; ?></td>
			<td><?php echo TABLE_HEADING_DESCRIPTION; ?></td>
		  </tr> 
		<?php
		for ($z=0, $t=count($list[$i]['data']); $z<$t; $z++) {
		  ?>
		  <tr>
			<td><?php echo $list[$i]['data'][$z]['name']; ?></td>
			<td><?php echo ((isset($orders_status_array[$list[$i]['data'][$z]['orders_status']])) ? $orders_status_array[$list[$i]['data'][$z]['orders_status']] : TEXT_PAYPAL_WEBHOOK_STATUS_NOT_DEFINED); ?></td>
			<td><?php echo $list[$i]['data'][$z]['description']; ?></td>
		  </tr>
		  <?php
		}
		?>
		<tr>
		  <td colspan="3">
			<a class="btn btn-success btn-sm" href="<?php echo xtc_href_link('paypal_webhook.php', 'action=edit&id='.$list[$i]['id']); ?>"><?php echo BUTTON_EDIT; ?></a>
			<a class="btn btn-danger btn-sm" href="<?php echo xtc_href_link('paypal_webhook.php', 'action=delete&id='.$list[$i]['id']); ?>"><?php echo BUTTON_DELETE; ?></a>
		  </td>
		</tr>
		<?php
	  }
	} else {
	  echo '<div class="info_message">'.TEXT_PAYPAL_WEBHOOK_INFO.'</div>';
	}
  }
?>
</table>
			
<?php 
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
